package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.model.FacilityInfo;
import gov.va.med.mhv.usermgmt.data.repository.FacilityInfoRepository;
import gov.va.med.mhv.usermgmt.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.service.FacilityInfoService;

@Component
public class FacilityInfoServiceImpl implements FacilityInfoService {

	protected static Logger log = LogManager.getLogger(FacilityInfoServiceImpl.class);

	@Autowired
	private FacilityInfoRepository facilityInfoRepository;

	@Override
	public FacilityInfo saveFacilityInfo(FacilityInfo facilityInfo) {
		FacilityInfo storedFacilityInfo = null;
		try {
			storedFacilityInfo = facilityInfoRepository.save(facilityInfo);
		} catch (Exception e) {
			log.error("Error in storing FacilityInfo details : ", e);
			throw new MHVRuntimeException("Error in storing FacilityInfo details");
		}
		return storedFacilityInfo;
	}

	@Override
	public List<FacilityInfo> getAllFacilityInfos() {
		List<FacilityInfo> facilityInfos = null;
		try {
			facilityInfos = facilityInfoRepository.getAllFacilityInfos();
		} catch (Exception e) {
			log.error("Error in fetching getAllFacilityInfos() ", e);
			throw new MHVRuntimeException("Error in fetching getAllFacilityInfos()");
		}
		return facilityInfos;
	}

	@Override
	public List<FacilityInfo> queryByStationNumber(String stationNumber) {
		List<FacilityInfo> facilityInfos = null;
		try {
			facilityInfos = facilityInfoRepository.queryByStationNumber(stationNumber);
		} catch (Exception e) {
			log.error("Error in fetching queryByStationNumber() " + stationNumber, e);
			throw new MHVRuntimeException("Error in fetching queryByStationNumber()");
		}
		return facilityInfos;
	}

}
